/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.trace;

import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.PerfLogger;

final class TraceMessage {
    private final TraceLevel level;
    private final String msg;
    private final boolean newline;
    private final long ts = System.currentTimeMillis();

    TraceMessage(TraceLevel traceLevel, String string) {
        this(traceLevel, string, false);
    }

    TraceMessage(TraceLevel traceLevel, String string, boolean bl) {
        this.level = traceLevel;
        this.msg = string;
        this.newline = bl;
    }

    public String toString() {
        if (PerfLogger.perfLogEnabled()) {
            return new StringBuffer().append("ts: ").append(this.ts).append(' ').append(this.level).append(": ").append(this.msg).toString();
        }
        return new StringBuffer().append(this.level).append(": ").append(this.msg).toString();
    }

    public TraceLevel getLevel() {
        return this.level;
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (PerfLogger.perfLogEnabled()) {
            stringBuffer.append("ts: ").append(this.ts).append(' ');
        }
        if (this.level.equals(TraceLevel.DEFAULT)) {
            stringBuffer.append(this.msg);
        } else {
            stringBuffer.append(this.level).append(": ").append(this.msg);
        }
        if (this.newline) {
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public String getMsg() {
        return this.msg;
    }

    public long getTimestamp() {
        return this.ts;
    }
}

